/**************************************************************************************************
 *  Services performed by FREESCALE in this matter are performed AS IS and without any warranty.  *
 *  CUSTOMER retains the final decision relative to the total design and functionality of the     *
 *  end product. FREESCALE neither guarantees nor will be held liable by CUSTOMER for the         *
 *  success of this project. FREESCALE disclaims all warranties, express, implied or statutory    *
 *  including, but not limited to, implied warranty of merchantability or fitness for a           *
 *  particular purpose on any hardware, software ore advise supplied to the project by FREESCALE, *
 *  and or any product resulting from FREESCALE services . In no event shall FREESCALE be         *
 *  liable for incidental or consequential damages arising out of this agreement. CUSTOMER        *
 *  agrees to hold FREESCALE harmless against any and all claims demands or actions by anyone     *
 *  on account of any damage, or injury, whether commercial, contractual, or tortuous, rising     *
 *  directly or indirectly as a result of the advise or assistance supplied CUSTOMER in           *
 *  connection with product, services or goods supplied under this Agreement.                     *
 **************************************************************************************************/

#ifndef __IICV1Driver
#define __IICV1Driver

#include "FslTypes.h"
#include "IICV1HAL_JM.h" /* include peripheral declarations */


#define     IICV1_BUSY    (u8IICV1DriverStatus & (1<<IIC_FLAGS_BUSY))

void vfnIICV1Init(void);
void vfnIICV1Write(UINT8 u8SlaveAddress, UINT8 *pu8DataOut, UINT8 u8Size);
void vfnIICV1Read(UINT8 u8SlaveAddress, UINT8 *pu8DataIn, UINT8 u8Size);
void vfnIICV1RandomRead(UINT8 u8SlaveAddress, UINT8 *pu8DataOut, UINT8 u8SizeOut,
UINT8 *pu8DataIn, UINT8 u8SizeIn);
void vfnIICV1Interrupt(void);

extern UINT8 volatile u8IICV1DriverStatus;
extern void (*const vfnapIICV1Driver[])(void);
extern UINT8 gu8IICV1ActualState;             

typedef enum
{
     IIC_FLAGS_IDLE,
     IIC_FLAGS_BUSY,
     IIC_FLAGS_READY,
     IIC_FLAGS_WRITE_OK,
     IIC_FLAGS_ERROR
} eIICV1DriverStatus;

/*****************************************************************************/
#endif
